unit MainUnit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, mdMailSlot;

type
  TfmMain = class(TForm)
    mdWinPopup: TmdWinPopup;
    grpSender: TGroupBox;
    edSender: TEdit;
    grpName: TGroupBox;
    edReciever: TEdit;
    grbMessage: TGroupBox;
    memMessage: TMemo;
    Bevel: TBevel;
    btnClose: TButton;
    btnNew: TButton;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    procedure mdWinPopupMessage(Sender: TObject; AReciever, ASender,
      AMsg: string);
    procedure btnCloseClick(Sender: TObject);
    procedure btnNewClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  fmMain: TfmMain;

implementation

{$R *.DFM}

procedure TfmMain.mdWinPopupMessage(Sender: TObject; AReciever, ASender,
  AMsg: string);
begin
  If NOT edSender.Enabled Then
  Begin
    edSender.Text := ASender;
    edReciever.Text := AReciever;
    memMessage.Text := AMsg;
  end;
end;

procedure TfmMain.btnCloseClick(Sender: TObject);
begin
  Close;
end;

procedure TfmMain.btnNewClick(Sender: TObject);
begin
  Case btnNew.Tag of
    0 :  // New message
    Begin
      edSender.Clear;
      edReciever.Clear;
      memMessage.Clear;
      edSender.Enabled := True;
      edReciever.Enabled := True;
      memMessage.Enabled := True;
      btnNew.Tag := 1;
      btnNew.Caption := '&Send';
      ActiveControl := edSender;
    end;
    1 :  // Send message
    Begin
      mdWinPopup.Send(edReciever.Text,
                      edSender.Text,
                      edReciever.Text,
                      memMessage.Text);
      edSender.Enabled := False;
      edReciever.Enabled := False;
      memMessage.Enabled := False;
      btnNew.Caption := '&New';
      btnNew.Tag := 0;
      ActiveControl := btnNew;
    end;
  end;
end;

end.
